/* This magma code accompanies the article B. Banwait, F. Fité, D. Loughran - Del Pezzo surfaces over finite fields and their Frobenius traces.

It verifies that the explicit del Pezzo surfaces of degree 1 stated in the proof of Theorem 1.5 have the claimed traces. 

*/

WP<x,y,z,w>:=WeightedProjectiveSpace(Rationals(),[1,1,2,3]);

/*Calculates the number of points on the del Pezzo surface of degree 1 given by the weighted homogeneous equation g = 0 over a finite field k */
NoPoints := function(g,k) 
 NoPts:=0;
 for x,y,z,w in k do
  if Evaluate(g, [x,y,z,w]) eq 0 and [x,y] ne [0,0] then /*If not the anticanonical point*/
   NoPts:=NoPts+1;
  end if;
 end for;
 NoPts:=NoPts/(#k-1) + 1; /*Divide through by the action of Gm and add the anticanonical point*/
 return NoPts;
end function;

TraceOfFrob := function(g,k) 
 return (NoPoints(g,k) - 1 - (#k)^2)/#k; 
end function;

//Has trace 5 when q=3.
q:=3;
k<u>:=FiniteField(q);
WPk<x,y,z,w>:=ChangeRing(WP,k);
g:=-w^2 + z^3 + z*(2*x^4 + x^2*y^2 + 2*y^4) + x^6 + 2*x^4*y^2 + y^6;
X:=Scheme(WPk,g); 
printf "q = %o, Trace = %o, Is non-singular = %o \n", q, TraceOfFrob(g,k), IsNonSingular(X);
printf "Equation = %o \n \n", g;

//Has trace 5 when q=4.
q:=4;
k<u>:=FiniteField(q);
WPk<x,y,z,w>:=ChangeRing(WP,k);
g:=w^2 + x*z*w + (x^3 + u^2*x^2*y + u*x*y^2 + y^3)*w + z^3 + (u^2*x^4 + x^3*y + x^2*y^2)*z + u^2*x^4*y^2 + u*x^3*y^3 + x^2*y^4;
X:=Scheme(WPk,g); 
printf "q = %o, Trace = %o, Is non-singular = %o \n", q, TraceOfFrob(g,k), IsNonSingular(X);
printf "Equation = %o \n \n", g;

//Has trace 4 when q=2
q:=2;
k<u>:=FiniteField(q);
WPk<x,y,z,w>:=ChangeRing(WP,k);
g:=w^2  + w*(x^3 + x^2*y + y^3) + z^3 + z*(x^4 + x^3*y + y^4);
X:=Scheme(WPk,g); 
printf "q = %o, Trace = %o, Is non-singular = %o \n", q, TraceOfFrob(g,k), IsNonSingular(X);
printf "Equation = %o \n \n", g;

//Has trace 3 when q=2.
q:=2;
k<u>:=FiniteField(q);
WPk<x,y,z,w>:=ChangeRing(WP,k);
g:=w^2 + y*z*w + (x^3 + x*y^2)*w + z^3 + (x^4 + x*y^3)*z + (x^5*y + x^4*y^2 + x^3*y^3 + x^2*y^4 + y^6);
X:=Scheme(WPk,g);
printf "q = %o, Trace = %o, Is non-singular = %o \n", q, TraceOfFrob(g,k), IsNonSingular(X);
printf "Equation = %o \n \n", g;


