/* This magma code accompanies the article B. Banwait, F. Fité, D. Loughran - Del Pezzo surfaces over finite fields and their Frobenius traces.

It verifies the claim in the proof of Lemma 5.2 that the stated del Pezzo surface of degree 2 has only two rational points not on its lines, and that these lie on the ramification locus

*/

q:=17;
k:=FiniteField(q);
P2<x,y,z>:=ProjectiveSpace(k,2);

lam:=k!2;
mu:=k!3;
nu:=k!4;


//We work with the explicit description of the lines via the bitangents of the plane quartic
Lines:=[x + lam*y, x - lam*y, y + mu*x, y - mu*x, z + nu*x, z - nu*x,
x + lam*z, x - lam*z, y + mu*z, y - mu*z, z + nu*y, z - nu*y,

(1 + mu*nu)*x + (1 + nu*lam)*y + (1 - lam*mu)*z,
(1 + mu*nu)*x + (1 + nu*lam)*y - (1 - lam*mu)*z,
(1 + mu*nu)*x - (1 + nu*lam)*y + (1 - lam*mu)*z,
(1 + mu*nu)*x - (1 + nu*lam)*y - (1 - lam*mu)*z,

(1 + mu*nu)*x + (1 - nu*lam)*y + (1 + lam*mu)*z,
(1 + mu*nu)*x + (1 - nu*lam)*y - (1 + lam*mu)*z,
(1 + mu*nu)*x - (1 - nu*lam)*y + (1 + lam*mu)*z,
(1 + mu*nu)*x - (1 - nu*lam)*y - (1 + lam*mu)*z,

(1 - mu*nu)*x + (1 + nu*lam)*y + (1 + lam*mu)*z,
(1 - mu*nu)*x + (1 + nu*lam)*y - (1 + lam*mu)*z,
(1 - mu*nu)*x - (1 + nu*lam)*y + (1 + lam*mu)*z,
(1 - mu*nu)*x - (1 + nu*lam)*y - (1 + lam*mu)*z,

(1 - mu*nu)*x + (1 - nu*lam)*y + (1 - lam*mu)*z,
(1 - mu*nu)*x + (1 - nu*lam)*y - (1 - lam*mu)*z,
(1 - mu*nu)*x - (1 - nu*lam)*y + (1 - lam*mu)*z,
(1 - mu*nu)*x - (1 - nu*lam)*y - (1 - lam*mu)*z];

g:= ((1 - mu^2*nu^2)*x^2 + (1 - nu^2*lam^2)*y^2 + (1 - mu^2*lam^2)*z^2)^2 
- 4*(1 - lam^2*mu^2*nu^2)*((1 - nu^2)*x^2*y^2 + 
(1 -lam^2)*y^2*z^2 + (1 - mu^2)*z^2*x^2);

g:=g*8;

print "The plane quartic:";
print g; print " ";
print "The bitangents of the plane quartic:";
print Lines; print " ";

C:=Scheme(P2,g);

NoPoints:=0;
for x,y,z in k do
 if IsSquare(Evaluate(g, [x,y,z])) and [x,y,z] ne [0,0,0] then
  if Evaluate(g, [x,y,z]) ne 0 then
   NoPoints:=NoPoints+2;
  else 
   NoPoints:=NoPoints+1;
  end if;
 end if;
end for;
printf "1 + 8q + q^2 =  %o \n", 1 + 8*q + q^2;
printf "Number of rational points the del Pezzo surface = %o \n",NoPoints/(q-1);

NotOnLine:=Set([P2![0,6,1], P2![0,11,1]]);
for x,y,z in k do
 if IsSquare(Evaluate(g, [x,y,z])) and [x,y,z] ne [0,0,0] then
  OnLine:=false;
  for L in Lines do
   if Evaluate(L, [x,y,z]) eq 0 then
    OnLine:=true;
   end if;
  end for;
  if OnLine eq false then
   NotOnLine:=Include(NotOnLine, P2![x,y,z]);
  end if;
 end if;
end for;


printf "Points not on a line : \n";
for P in NotOnLine do
 printf "%o. In the ramification locus? %o \n", P, P in C;
end for;
