jackMean7 <- function(x, compuVar = T, ...) {
	# Utilizando la funcin sapply en lugar de un bucle for
	# Permite tambin decidir si solamente se corrige el sesgo o se calcula tambin la varianza
	n <- length(x)
	mi <- sapply(1:n, imean, x, ...)
	# Utilizando un producto escalar en lugar de las funciones mean y var
	m. <- (mi %*% rep(1,n)) / n
	jMean <- n * mean(x, ...) - (n-1) * m.
	if (compuVar) {
		varJMean = ((n-1)/n) * (mi - m.)^2 %*% rep(1,n)
		jack <- list(
			JMean = jMean,
			VarJMean = varJMean
		)
	}
	else
		jack <- list(JMean = jMean)
	return(jack)
}
