jackknife <- function(x, stat=mean, ...) {
	# Funcin jackknife general, para cualquier estadstico que sea funcin de un vector
	n <- length(x)
	mi <- sapply(1:n, istat, x, stat, ...)
	# Utilizando un producto escalar en lugar de las funciones mean y var
	m. <- (mi %*% rep(1,n)) / n
	jack <- list(
		JStat = n * stat(x, ...) - (n-1) * m.,
		varJStat = ((n-1)/n) * (mi - m.)^2 %*% rep(1,n)
	)
	return(jack)
}
