jackknife <-
function(x, jackVector=F, stat=mean, ...) {
	# Funcin jackknife general, para cualquier estadstico que sea funcin de un vector
	# Utilizando un producto escalar en lugar de las funciones mean y var
	# Devuelve el valor del estadstico corregido para el sesgo,
	# la estimacin del sesgo, la estimacin jackknife de la varianza,
	# y permite decidir si en el resultado se incluye el vector de valores jackknife
	n <- length(x)
	n1 <- n - 1
	unos <- rep(1,n)
	statx <- stat(x, ...)
	stati <- sapply(1:n, istat, x, stat, ...)
	stat. <- (stati %*% unos) / n
	bias <- n1 * (stat. - statx)
	jStat <- statx - bias
	varJStat <- (n1/n) * (stati - stat.)^2 %*% unos
	if (!jackVector) stati <- NULL
	jack <- list(
		JStat = jStat,
		VarJStat = varJStat,
		Bias = bias,
		Stat_i = stati
	)
	return(jack)
}
