jackknife.apply <- function(x, stat, output = c("bias.correct","var","jack.values"), ...) {
	n <- length(x)
	estad.val <- stat(x, ...)
	x <- matrix(x, nrow=n, ncol=n)
	x_i <- matrix(x[lower.tri(x)|upper.tri(x)],ncol=n)
	estads_i <- apply(x_i, 2, stat, ...)
	estads. <- mean(estads_i)
	result <- list()
	if (any(pmatch(output,"bias.correct",nomatch=0))) {
	   sesgo <- (n-1)*(estads. - estad.val)
     jEstad <- estad.val - sesgo
     attr(jEstad,"bias") <- sesgo
	   result <- c(result, list(JStat = jEstad))
  }
	if (any(pmatch(output,"var",nomatch=0)))
	   result <- c(result, list(varJestad = ((n-1)/n) * sum((estads_i - estads.)^2)))
  if (any(pmatch(output,"jack.values",nomatch=0)))
	   result <- c(result, list(Stats_i = estads_i))
  attr(result, "stat.val") <- estad.val
  attr(result, "stat") <- deparse(substitute(stat))	
	return(result)
}
