jackknife <- function(x, stat, output = c("bias.correct","var","jack.values"), ...) {
	n <- length(x)
	estads_i <- numeric(length=n)
	estad.val <- stat(x, ...)
	for (i in 1:n) {
		estads_i[i] <- stat(x[-i], ...)
	}
	estads. <- mean(estads_i)
	result <- list()
	if (any(pmatch(output,"bias.correct",nomatch=0))) {
	   sesgo <- (n-1)*(estads. - estad.val)
     jEstad <- estad.val - sesgo
     attr(jEstad,"bias") <- sesgo
	   result <- c(result, list(JStat = jEstad))
  }
	if (any(pmatch(output,"var",nomatch=0)))
	   result <- c(result, list(varJestad = ((n-1)/n) * sum((estads_i - estads.)^2)))
  if (any(pmatch(output,"jack.values",nomatch=0)))
	   result <- c(result, list(Stats_i = estads_i))
  attr(result, "stat.val") <- estad.val
  attr(result, "stat") <- deparse(substitute(stat))	
	return(result)
}
