data(mtcars)

class(mtcars) # data.frame

library(tidyr)  # para preparar los datos en un formato adecuado
library(dplyr)  # para manipular los datos
library(tibble) # para manipular "tibbles"

mtcars <- as_tibble(mtcars)
class(mtcars) # tbl_df

mtcars %>% head

glimpse(mtcars)   # equivalente a str()
mtcars %>% glimpse  

# Filtrar filas

cars_1carb <- mtcars %>% filter(carb == 1)

cars_bajo_consumo <- cars_1carb %>% filter(mpg >= 30)

# Seleccionar columnas

mtcars_simple <- mtcars %>% select(mpg,hp,wt)

# Nuevas columnas

mtcars_wide <- mtcars %>% mutate(hp.cyl = hp/cyl)

# Resumir según grupos

mtcars %>% group_by(carb) %>% summarise(media.mpg=mean(mpg), sd.mpg=sd(mpg))

# Resumen de medias ordenadas

mtcars %>% group_by(carb) %>% 
  summarise(media.mpg=mean(mpg), sd.mpg=sd(mpg)) %>% arrange(desc(media.mpg))
