#################################################
#  Preparar una función que presente un boxplot
#   de una variable continua segmentada por una variable categórica
#   de una base de datos
#
#################################################


data()
data("mtcars")
help("mtcars")
head(mtcars)
str(mtcars)

# Análisis univariante de las variables continuas 
#   respecto a alguna variable categorica

matcars.cont <- c(1,3,4,5,6,7)      # variables continuas
matcars.disc <- c(2,8,9,10,11)      # variables categóricas


# Llamada individual de la función
myboxplot0(1, 2, mtcars)
myboxplot0(1, 2, mtcars, horizontal=T)  # error

myboxplot1(1, 2, mtcars, horizontal=T)

myboxplot2(1, 2, mtcars, colores=F, horizontal=F)
myboxplot1(1, 2, mtcars, horizontal=F, col="lightgreen")



# Loops

for (i in matcars.cont){
  myboxplot1(i, 2, mtcars, horizontal=T)
}
# Nada mas se tiene en consola el último


# Crea un documento PDF con todos los gráficos de una variable categórica
pdf("myboxplotloop.pdf")
for (i in matcars.cont){
  myboxplot1(i,2,mtcars,horizontal=T)
}
dev.off()
# El PDF se guarda en la carpeta de trabajo: getwd()

# Crea un documento PDF con todos los gráficos
#   de todas las variables continuas y categóricas
pdf("myboxplotloop2.pdf")
for (i in matcars.disc){
  for (j in matcars.cont){
     myboxplot1(j,i,mtcars,horizontal=T)
  }
}
dev.off()


########################################
# Funciones
########################################

# Realiza un boxplot de una variable continua respecto a una variable categórica
#   en una base de datos. Personaliza el titulo principal y el título de los ejes.

myboxplot0 <- function(var.cont.ind, var.cat.ind, datos) {
   boxplot(datos[[var.cont.ind]] ~ datos[[var.cat.ind]], data=datos,
           main=paste(names(datos)[var.cont.ind]," vs ", names(datos)[var.cat.ind]),
           xlab=names(datos)[var.cat.ind], ylab=names(datos)[var.cont.ind])
}

# Igual que el anterior pero se puede añadir más argumentos para modificar 
#   el boxplot
myboxplot1 <- function(var.cont.ind, var.cat.ind, datos, ...) {
   boxplot(datos[[var.cont.ind]] ~ datos[[var.cat.ind]], data=datos,
           main=paste(names(datos)[var.cont.ind]," vs ", names(datos)[var.cat.ind]),
           xlab=names(datos)[var.cat.ind], ylab=names(datos)[var.cont.ind], ...)
}

# Boxplot con colores o sin colores
myboxplot2 <- function(var.cont.ind, var.cat.ind, datos, colores= FALSE, ...) {
    if (colores){
        boxplot(datos[[var.cont.ind]] ~ datos[[var.cat.ind]], data=datos,
                main=paste(names(datos)[var.cont.ind]," vs ", names(datos)[var.cat.ind]),
                xlab=names(datos)[var.cat.ind], ylab=names(datos)[var.cont.ind],
                col="lightgreen", ...)
    }
    else {
       boxplot(datos[[var.cont.ind]] ~ datos[[var.cat.ind]], data=datos,
               main=paste(names(datos)[var.cont.ind]," vs ", names(datos)[var.cat.ind]),
               xlab=names(datos)[var.cat.ind], ylab=names(datos)[var.cont.ind], ...)
    }
}

# Más corto:
myboxplot2 <- function(var.cont.ind, var.cat.ind, datos, colores= FALSE, ...) {
      boxplot(datos[[var.cont.ind]] ~ datos[[var.cat.ind]], data=datos,
              main=paste(names(datos)[var.cont.ind]," vs ", names(datos)[var.cat.ind]),
              xlab=names(datos)[var.cat.ind], ylab=names(datos)[var.cont.ind],
              col=ifelse(colores, "lightgreen", "lightgrey"), ...)
}

# FIN