###################################################
### chunk number 1: 
###################################################
data(mtcars)
str(mtcars)
help(mtcars)


###################################################
### chunk number 2: 
###################################################
gasolina <- read.table("gasolina.txt", header=T, sep=" ")
dim(gasolina)
n <- dim(gasolina)[1]     # nmero de observaciones
p <- dim(gasolina)[2] - 1 # nmero de variables regresoras
colnames(gasolina)


###################################################
### chunk number 3: 
###################################################
gasolina[,7:11] <- lapply(gasolina[,7:11],as.factor)
summary(gasolina)


###################################################
### chunk number 4: 
###################################################
library(cluster)

Y <- gasolina[,1]
Delta <- daisy(gasolina[,-1],type=list(asymm=c("b1","b2")))
class(Delta)


###################################################
### chunk number 5: 
###################################################
mds <- cmdscale(Delta^(1/2), k = n-1, eig = TRUE)
names(mds)
round(mds$points[,1],4)  # primera coordenada principal


###################################################
### chunk number 6: 
###################################################
plot(mds$points[,1],mds$points[,2],
     main="Representacin en dimensin reducida dim=2",
     xlab="Coordenada principal 1", ylab="Coordenada principal 2",
     pch=19, col="red")
abline(h=0)
abline(v=0)


###################################################
### chunk number 7: 
###################################################
plot(mds$points[,1],mds$points[,2],
     main="Representacin en dimensin reducida dim=2",
     xlab="Coordenada principal 1", ylab="Coordenada principal 2",
     pch=19, col="red")   # falta identificar los puntos
abline(h=0)
abline(v=0)


###################################################
### chunk number 8: 
###################################################
m <- sum(mds$eig > 1.0e-15)
mds <- cmdscale(Delta^(1/2), k = m, eig = TRUE)
X <- mds$points


###################################################
### chunk number 9: 
###################################################
ValoresPropios <- mds$eig
CorrCuadrado <- cor(Y,X)^2


###################################################
### chunk number 10: 
###################################################
aux <- CorrCuadrado*ValoresPropios/sum(CorrCuadrado*ValoresPropios)
c.pred <- c(0,cumsum(aux))


###################################################
### chunk number 11: 
###################################################
plot(0:m,1-c.pred,
     xlab="Nmero de coordenadas principales",
     ylab="1 - Predictibilidad",
     ylim=c(0,0.2),
     type="l")
abline(v=3,lty=2,col="blue")


###################################################
### chunk number 12: 
###################################################
plot(0:m,1-c.pred,
     xlab="Nmero de coordenadas principales",
     ylab="1 - Predictibilidad",
     ylim=c(0,0.2),
     type="l")
abline(v=3,lty=2,col="blue")


###################################################
### chunk number 13: 
###################################################
ValoresPropios[1:3]
CorrCuadrado[1:3]


###################################################
### chunk number 14: 
###################################################
Xr <- X[,1:3]
rdb <- lm(Y ~ Xr)
summary(rdb)


###################################################
### chunk number 15: 
###################################################
Xr <- X[,c(1,3)]
rdb <- lm(Y ~ Xr)
summary(rdb)


###################################################
### chunk number 16: 
###################################################
Yc <- Y - mean(Y)
rdbc <- lm(Yc ~ 0+Xr)
summary(rdbc)


###################################################
### chunk number 17: 
###################################################
gasolina[33,] <- c(NA,183.5,151,3.80,3.908,18.22,1,0,4,4,2)
d <- as.matrix(daisy(gasolina[,-1],type=list(asymm=c("b1","b2"))))[-33,33]
b <- diag(X %*% t(X))
x.new <- (1/2)* diag(ValoresPropios^(-1)) %*% t(X) %*% (b-d)
y.pred <- t(c(1,x.new[c(1,3)])) %*% rdb$coef
y.pred
y.pred <- mean(Y) + sum(x.new[c(1,3)] * rdbc$coef)
y.pred


###################################################
### chunk number 18: 
###################################################
library(ade4)
is.euclid(Delta^(1/2))


